//  GLiveStatusManager.h
//  G-live
//  Created by Gaojin Hsu on 5/30/16.
//  Copyright © 2016 陈伯伦. All rights reserved.

#import <Foundation/Foundation.h>
#import "GIntroduceView.h"
//细分用户的角色
typedef NS_ENUM(NSUInteger,UserRole){
    /**未知角色*/
    UserRoleUnknow,
    /**web*/
    UserRoleWeb,
    /**phone*/
    UserRolePhone,
    /**pc*/
    UserRolePc
};

typedef NS_ENUM(NSUInteger, RoomJoinStatus)
{
    RoomJoinNone,
    RoomJoinSuccess,
    RoomJoinReconnect
};



typedef NS_ENUM(NSUInteger,LiveType){
    /**
     *视频文档模式观看直播
     */
    WatchLive=1,

    /**
     *视频文档模式发布直播
     */
    ReleaseLive,

    /**
     *发布直播,纯视频横屏模式
     */
    ReleaseLivePureVideo,


    /**
     *竖屏纯视频发布
     */
    PortraitVideo,

    /**
     *ipad 观看端
     */
    IpadWatchLive,
};




typedef NS_ENUM(NSUInteger,graphicsQualityType){
    /**
     *超清
     */
    superhD=3,
    /**
     *高清
     */
    highD=1,

    /**
     *标清
     */
    standardD,
};




typedef NS_ENUM(NSUInteger,ViewType){

    SmallVideoViewType=1,
    /**
     *提醒类弹框（并发已满、网络故障）
     */
    ErrorViewType,
    /**
     *点名
     */
    RollViewType,

    /**
     *红包
     */
    HongBaoViewType,


    /**
     *抽奖
     */
    LotteryViewType,

    /**
     *投票
     */
    VoteViewType,


    /**
     *答题卡
     */
    CardViewType,


    /**
     *广播消息类型
     */
    BroadcastViewType,
};



typedef NS_ENUM(NSUInteger,DirectType){
    GoToForward=1,
    GoToBack,
    GoToNull,
};





@interface GSHongBaoMsg : NSObject
@property(strong, nonatomic)NSString* hongBaoStrid;
@property(strong, nonatomic)GSGrabInfo* grabInfo;
@property(assign, nonatomic)int hongBaoType;
@end





/**
 *  直播状态管理类
 */
@interface GLiveStatusManager : NSObject
+(instancetype)sharedInstance;
/**
 *  清除数据
 */
- (void)liveStatusclean;

/**
 * 由于退出，清除数据
 */
-(void)liveStatuscleanByQuit;


-(BOOL)isRoomJoinSuccess;
-(BOOL)isRoomJoinReconnect;
-(BOOL)isRoomHaveLod;//会议中是否有插播
/**
 *  我的userID
 */
@property (nonatomic, assign)long long myUserID;

/**
 *  我的角色
 */
@property (nonatomic, assign)GSUserRole  myRole;

/**
 *  在线人数
 */
@property (nonatomic, assign) NSUInteger onlineNum;

/**
 *  直播名称
 */
@property (nonatomic, copy) NSString *liveName;

/**
 *  直播状态
 */
@property (nonatomic, assign)GSBroadcastStatus status;

/**
 *  是否显示插播
 */
@property (nonatomic, assign) BOOL isLodShowing;

/**
 *  是否显示视频
 */
@property (nonatomic, assign) BOOL isVideoShowing;

/**
 *  我的麦克风是否打开
 */
@property (nonatomic, assign) BOOL isMyMicrophoneOn;

/**
 *  直播是否禁止聊天
 */
@property (nonatomic, assign) BOOL isChatForbidden;
@property (nonatomic, assign) BOOL versionTip;
//----------------------------------------
@property (nonatomic, assign) BOOL needAlert;//直播列表页是否需要弹出登录失败提示框
/**YES表示组织者登录了列表*/
@property (nonatomic,assign) BOOL isListOff;
/**是否在rootView界面，用来判断是否进行URL登录检测*/
@property (nonatomic,assign) BOOL isRootView;
@property (nonatomic,assign) BOOL isVod;//YES 在观看点播
@property (nonatomic,assign) BOOL isSelfCloseVideo;//YES 手动关闭直播视频,是否取消订阅
@property (nonatomic,assign) BOOL isLiveing;//是否在直播间
@property (nonatomic,assign) BOOL hiddenAchievement;//关闭成就页面
@property (nonatomic, assign) BOOL logIning;   //登录状态
@property(nonatomic,assign)LiveType listLiveType;      //直播管理直播类型
@property(nonatomic,assign)graphicsQualityType listQualityType;//主播管理直播质量
@property(nonatomic,assign)LiveType liveType;//直播类型
@property(nonatomic,assign)graphicsQualityType qualityType;
@property (nonatomic, strong) NSMutableArray *rewardModelArray;//打赏者信息
@property (nonatomic, strong) NSString *roomNumber;//房间号
@property(nonatomic,strong)NSMutableArray *serverDocLists;     //存储所有的文档GSDocument
@property(nonatomic,strong)NSMutableArray *DocCellSimModalLists;
@property(nonatomic,strong)NSMutableArray *DocUploadModalLists;    //从相册或者拍照上传的图片的docID 存一下
@property(nonatomic,strong)NSMutableArray *fileIdList;    //上传下载文件的id列表
@property(assign, nonatomic)unsigned int gCurrentPageID;         //当前的页码id
@property(assign, nonatomic)unsigned int gCurrentDocID;          //当前的文档id
@property(assign, nonatomic)unsigned int gCurrentDocAnnoStep;        //当前的动画步骤
@property(strong, nonatomic)GSDocument *gCurrentDoc;       //当前的文档
@property(strong, nonatomic)NSMutableArray *gCurrentReLoadUpDocArray;       //当前的需要重新上传的文档数组
@property(nonatomic, assign) BOOL isChatDisabled;
@property(nonatomic,assign)BOOL isLiveStartHide;//开始直播按钮是否隐藏
@property(nonatomic,assign)BOOL isVideoUseIng;  //标记视频开关状态
@property(nonatomic,assign)BOOL isVoiceUseIng;  //标记音频开关状态
@property(nonatomic,assign,readonly) int publishImageIndex;
@property(nonatomic,strong)AVCaptureVideoPreviewLayer *gPreviewLayer;  //预览图层
@property(nonatomic,assign)BOOL isShowGuideImage;  //文档引导页面是否显示
@property(nonatomic,assign)BOOL isCameraActivateStatus;  //观看端的时候，摄像头是否已经打开状态
@property(nonatomic,assign)BOOL isActivateMicrophoneStatus;  //麦克风的状态 ，便于恢复
@property(nonatomic,assign)BOOL isActivateMicrophoneStatusByReConnect;  //是重新连接开启麦克风
@property(nonatomic,assign)BOOL isCurrentVideoSelfActived;  //自己的视频在做直播
-(void)clearAllMyselfStatusData;  //清除状态
@property(nonatomic,assign)BOOL isDesktopShareShow;  //客户端允许显示不显示桌面共享的标志
@property(nonatomic,assign)BOOL isCurrentVideoSelfActivedBackFrontSwitch;  //自己的视频在做直播,然后切换前后视频
@property(nonatomic,assign)int  MainViewControllerNum;  //主界面是否已经被释放，不放到clearAllMyself里面
@property(nonatomic,assign)BOOL isCannotCaptureOutPut; //能不能传数据
@property(nonatomic,assign)BOOL isCurrentNetStatusOpened; //当前网络是开着的吗？
@property(nonatomic,assign)BOOL isAppWillEnterForeground; //要回前台了，解决发布端文档重置位置问题
@property(nonatomic,assign)BOOL isAudioExceptionInbackground; //发布端音频在后台是否被抢断过
@property(nonatomic,assign)BOOL isappInbackground; //程序是否在后台
@property(nonatomic,assign)BOOL isHaveRedTips; //是否有红包提示
@property(nonatomic, assign) BOOL isHongBaoEnable;  //yes enable 红包
@property(nonatomic, assign) BOOL isBarrageEnable;  //yes enable 弹幕
@property(nonatomic, assign) BOOL isDaShangEnable;  //yes enable 打赏
@property(nonatomic, assign)BOOL isOpenOnlineService; //是否开启在线客服
@property(nonatomic,assign)BOOL isFullScreenStatus; //是否是全屏状态  //包括文档和视频全屏
@property(nonatomic, assign)BOOL isPublishSystemAsRunning;
@property(nonatomic, assign)BOOL isPublishRtSDKAsRunning;
@property(nonatomic, assign)BOOL isPublishASByMe;

/**是否有简介信息*/
@property(nonatomic,assign,readonly)BOOL isHaveIntroduce;
//打赏的金额数组
@property(nonatomic,strong)NSMutableArray *rewardArray;
//是否自动推送qa
@property(nonatomic, assign) BOOL isbAutoPublishQuestion;
//是否显示rankButton
@property(nonatomic,assign)BOOL isrankButton;
//是否开启勋章功能
@property(nonatomic,assign)BOOL medalEnable;
//是否开启点赞功能
@property(nonatomic,assign)BOOL praiseEnable;
//讲台是否有人
@property(nonatomic,assign)BOOL isOnDeskTop;
//是否是组织者或者助教在讲台
@property (nonatomic, assign) BOOL isOrgDeskTop;
//是否是小班课
@property(nonatomic,assign)BOOL smallClass;
//在线用户id列表
@property (nonatomic, strong) NSMutableDictionary *onlineUserIDs;
//在线的Mic数组
@property(nonatomic,copy,readonly)NSArray*onlineMic;
//在线用户排序后的列表
@property(nonatomic,strong)NSArray *onlineUserSorted;
//总的在线人数
@property(assign,nonatomic)int onlineUserTotalNum;
//讲台上人的用户uid
@property (nonatomic, assign)long long podiumUserID;
//根据uid获取用户信息
-(GSUserInfo*)getUserInfoByUserId:(long long)userID;
//根据uid判断用户的类型
-(BOOL)isOrdinaryParticipantByUserId:(long long)userID;
//根据用户的信息获取用户的角色分类
-(UserRole)getUserRole:(GSUserInfo *)info;
//当前的角色
@property(assign, nonatomic) GSUserRole gCurrentUserRole;
//当前的用户名
@property(strong, nonatomic) NSString* gCurrentUserName;
//当前的用户的信息
@property(strong, nonatomic) GSUserInfo *currentUser;
//文档是否是全屏状态
@property(nonatomic,assign) BOOL isDocFullScreenStatus;
//Vod是否全屏
@property(nonatomic,assign) BOOL isVodVideoFullScreen;
//视频是否是全屏状态
@property(nonatomic,assign) BOOL isVideoFullScreenStatus;
//是否横屏
@property (nonatomic, assign) BOOL isLand;
/**构建发布图片的名称 */
-(NSString*)getNameForPublishImage;
//是否自己上讲台
@property(nonatomic, assign) BOOL isOnRostrum;
@property(nonatomic,assign) BOOL isDocVcCanRorate;
@property (nonatomic, strong) NSMutableDictionary *askerUserIDs;  //提问席用户
@property (nonatomic, assign) BOOL  isMyCameraOpen; //我的摄像头是否打开
@property(nonatomic,assign) GSBroadcastStatus currentCastStatus;
@property (nonatomic, assign) BOOL  isOnDesk; //是否在讲台
@property (nonatomic, assign) RoomJoinStatus  roomJoinStatus; //是否加入状态
@property (nonatomic, assign) BOOL  broadCastMsgViewStatus; //广播消息显示状态
@property (nonatomic, assign) BOOL  isKeyBoradShow; //键盘显示状态
@property (nonatomic, assign) BOOL onDeskLodShowing;
@property(nonatomic,assign)int  VodViewControllerNum;  //点播计数
@property(nonatomic,strong)GSUserInfo* OrganizerInitialStatusUser;
@property(nonatomic,strong)GSLiveIntroduceModal*  liveIntroduceModal; //直播简介信息
@property (nonatomic, assign) BOOL  isDocAnnoing; //文档标注正在显示
@property (nonatomic, assign) BOOL  isDocCanAnnoing; //文档正处于标注状态,用来控制是否响应手势
@property(nonatomic, assign) BOOL isAskerAnnoEnable;  //在提问席间上的标注使能
@property (nonatomic, assign) CGPoint  smallModePoint; //记住小窗的位置
@property (nonatomic, assign) BOOL  isSwitched; //记住小窗的位置
//问题是否自动发布
@property(nonatomic,assign)BOOL isQAAuto;

@property (nonatomic,assign) BOOL isShowPrivacyAlert;
@property (nonatomic,strong) NSString *webLaunchUrl;


@end
